package org.msh.tb.bd.dashboard.summaryrep.parser;

import org.msh.tb.bd.dashboard.DashboardIndicatorUtils;
import org.msh.tb.bd.dashboard.summaryrep.data.IndicatorRateData;
import org.msh.tb.bd.dashboard.summaryrep.data.SummaryIndicatorData;
import org.msh.utils.date.DateUtils;
import org.msh.utils.date.Period;

import java.util.Date;
import java.util.List;

/**
 * Created by mauri on 23/05/2017.
 * Generic parser used to generate population rate for indicators that calculates only one rate (01, 02, 03)
 */
public class PopulationIndicatorParser implements IndicatorParser {

    /**
     * The indicator code like 'indicator01' used by UI to generate some components
     */
    private String indicatorCode;

    public PopulationIndicatorParser(String indicatorCode) {
        this.indicatorCode = indicatorCode;
    }

    @Override
    public SummaryIndicatorData parse(List<Object[]> result, String locationDesc) {
        Float rate;

        if (result != null && result.size() > 0) {
            Object[] o = result.get(0);
            rate = (Float) o[3];
        } else {
            rate = new Float(0);
        }

        return new SummaryIndicatorData(locationDesc,
                "dashboard.last12months",
                indicatorCode,
                rate,
                null);
    }

    @Override
    public Period getPeriod() {
        return DashboardIndicatorUtils.getLast12MonthsPeriod();
    }

    @Override
    public SummaryIndicatorData parse(List<Object[]> result, String locationDesc, SummaryIndicatorData nationalResult) {
        SummaryIndicatorData data = parse(result, locationDesc);

        data.getIndicatorRates().get(0).setNationalRate(nationalResult.getIndicatorRates().get(0).getRate());

        return data;
    }

    public String getIndicatorCode() {
        return indicatorCode;
    }

    public void setIndicatorCode(String indicatorCode) {
        this.indicatorCode = indicatorCode;
    }
}
